<?php
/**
 * @file
 * Default theme implementation to present a picture configured for the
 * user's account.
 *
 * Available variables:
 * - $user_picture: Image set by the user or the site's default. Will be linked
 *   depending on the viewer's permission to view the user's profile page.
 * - $account: Array of account information. Potentially unsafe. Be sure to
 *   check_plain() before use.
 *
 * @see template_preprocess_user_picture()
 *
 * @ingroup themeable
 */
$user = $account;
?>

<?php if ($user_picture): ?>
  <div class="<?php print $classes; ?>">
    <?php
    if (isset($user->picture->uri)) {
      print theme_image_style(
              array(
                'style_name' => '70x100',
                'path' => $user->picture->uri,
                'attributes' => array(
                  'class' => 'avatar'
                )
              )
      );
    }
    else {
      print $user_picture;
    }
    ?>
  </div>
<?php endif; ?>
