<?php

/**
 * @file
 * template.php
 */

/**
 * Implements hook_css_alter().
 */
function bootstrap_lite_css_alter(&$css) {
  $theme_path = drupal_get_path('theme', 'bootstrap_lite');

  if ($bootstrap_cdn = theme_get_setting('bootstrap_lite_cdn')) {
    // Add CDN.
    if ($bootswatch = theme_get_setting('bootstrap_lite_bootswatch')) {
      $cdn = '//netdna.bootstrapcdn.com/bootswatch/' . $bootstrap_cdn . '/' . $bootswatch . '/bootstrap.min.css';
    }
    else {
      $cdn = '//netdna.bootstrapcdn.com/bootstrap/' . $bootstrap_cdn . '/css/bootstrap.min.css';
    }
    $css[$cdn] = array(
      'data' => $cdn,
      'type' => 'external',
      'every_page' => TRUE,
      'media' => 'all',
      'preprocess' => FALSE,
      'group' => CSS_THEME,
      'browsers' => array('IE' => TRUE, '!IE' => TRUE),
      'weight' => -2,
    );
    // Add overrides.
    $override = $theme_path . '/css/overrides.css';
    $css[$override] = array(
      'data' => $override,
      'type' => 'file',
      'every_page' => TRUE,
      'media' => 'all',
      'preprocess' => TRUE,
      'group' => CSS_THEME,
      'browsers' => array('IE' => TRUE, '!IE' => TRUE),
      'weight' => -1,
    );
  }
  if ($font_awesome = theme_get_setting('bootstrap_lite_font_awesome')) {
    $awesome = 'https://maxcdn.bootstrapcdn.com/font-awesome/' . $font_awesome . '/css/font-awesome.min.css';
    $css[$awesome] = array(
      'data' => $awesome,
      'type' => 'external',
      'every_page' => TRUE,
      'media' => 'all',
      'preprocess' => FALSE,
      'group' => CSS_THEME,
      'browsers' => array('IE' => TRUE, '!IE' => TRUE),
      'weight' => -2,
    );
  }
}

/**
 * Implements hook_js_alter().
 */
function bootstrap_lite_js_alter(&$js) {
  if (theme_get_setting('bootstrap_lite_cdn')) {
    $cdn = '//netdna.bootstrapcdn.com/bootstrap/' . theme_get_setting('bootstrap_lite_cdn') . '/js/bootstrap.min.js';
    $js[$cdn] = drupal_js_defaults();
    $js[$cdn]['data'] = $cdn;
    $js[$cdn]['type'] = 'external';
    $js[$cdn]['every_page'] = TRUE;
    $js[$cdn]['weight'] = -100;
  }
  if ('fixed-top' == theme_get_setting('bootstrap_lite_navbar_position')) {
    drupal_add_js('var themeTableHeaderOffset = function() { var offsetheight = jQuery("#navbar").height(); return offsetheight; }', 'inline');
    drupal_add_js(array('tableHeaderOffset' => 'themeTableHeaderOffset'), 'setting');
  }
}

/**
 * Implements hook_preprocess_html().
 */
function bootstrap_lite_preprocess_html(&$variables) {
  if ($navbar_position = theme_get_setting('bootstrap_lite_navbar_position')) {
    $variables['classes_array'][] = 'navbar-is-' . $navbar_position;
  }
  /*    if($navbar_position == 'fixed-top' && user_access('access administration bar') && !admin_bar_suppress(FALSE) && !$config->get('position_fixed') ){
    drupal_add_js(drupal_get_path('theme', 'bootstrap_lite') . '/js/navbar-fixed-top.js');
    }
    if($navbar_position == 'static-top'){
    drupal_add_js(drupal_get_path('theme', 'bootstrap_lite') . '/js/navbar-static-top.js');
    } */
}

/**
 * Implements hook_preprocess_page().
 */
function bootstrap_lite_preprocess_page(&$variables) {
  $no_old_ie_compatibility_modes = array(
    '#tag' => 'meta',
    '#attributes' => array(
      'http-equiv' => 'X-UA-Compatible',
      'content' => 'IE=edge',
    ),
  );
  drupal_add_html_head($no_old_ie_compatibility_modes, 'no_old_ie_compatibility_modes');

  $variables['navbar_classes_array'] = array('navbar');
  if ($navbar_position = theme_get_setting('bootstrap_lite_navbar_position')) {
    $variables['navbar_classes_array'][] = 'navbar-' . $navbar_position;
  }

  $variables['container_class'] = theme_get_setting('bootstrap_lite_container');

  if (theme_get_setting('bootstrap_lite_navbar_inverse')) {
    $variables['navbar_classes_array'][] = 'navbar-inverse';
  }
  else {
    $variables['navbar_classes_array'][] = 'navbar-default';
  }

  if (module_exists('toolbar')) {
    if (user_access('Use the administration toolbar')) {
      $variables['classes'][] = 'navbar-admin-bar';
    }
  }

  // Primary nav.
  $variables['primary_nav'] = FALSE;
  if ($variables['main_menu']) {
    // Build links.
    $variables['primary_nav'] = menu_tree(variable_get('menu_main_links_source', 'main-menu'));
    // Provide default theme wrapper function.
    $variables['primary_nav']['#theme_wrappers'] = array('menu_tree__system_primary_menu');
  }

  // Secondary nav.
  $variables['secondary_nav'] = FALSE;
  if ($variables['secondary_menu']) {
    // Build links.
    $variables['secondary_nav'] = menu_tree(variable_get('menu_secondary_links_source', 'user-menu'));
    // Provide default theme wrapper function.
    $variables['secondary_nav']['#theme_wrappers'] = array('menu_tree__system_secondary_menu');
  }

  if (!empty($variables['page']['sidebar_first']) && !empty($variables['page']['sidebar_second'])) {
    $variables['content_column_class'] = ' class="col-sm-6"';
  }
  elseif (!empty($variables['page']['sidebar_first']) || !empty($variables['page']['sidebar_second'])) {
    $variables['content_column_class'] = ' class="col-sm-9"';
  }
  else {
    $variables['content_column_class'] = ' class="col-sm-12"';
  }


}


/**
 * Implements hook_process_page().
 *
 * @see page.tpl.php
 */
function bootstrap_lite_process_page(&$variables) {
  $variables['navbar_classes'] = implode(' ', $variables['navbar_classes_array']);
}

/**
 * Returns HTML for a fieldset form element and its children.
 *
 * @param $variables
 *   An associative array containing:
 *   - element: An associative array containing the properties of the element.
 *     Properties used: #attributes, #children, #collapsed, #collapsible,
 *     #description, #id, #title, #value.
 *
 * @ingroup themeable
 */
function bootstrap_lite_fieldset($variables) {
  if (isset($variables['element']['#group_fieldset']) && !empty($variables['element']['#group_fieldset'])) {
    return theme_fieldset($variables);
  }
  $element = $variables['element'];
  element_set_attributes($element, array('id'));
  _form_set_class($element, array('form-wrapper'));
  $element['#attributes']['class'][] = 'panel';
  $element['#attributes']['class'][] = 'panel-default';
  $output = '<fieldset' . drupal_attributes($element['#attributes']) . '>';
  if (!empty($element['#title'])) {
    // Always wrap fieldset legends in a SPAN for CSS positioning.
    $output .= '<legend class="panel-heading"><span class="fieldset-legend">' . $element['#title'] . '</span></legend>';
  }
  $output .= '<div class="fieldset-wrapper panel-body">';
  if (!empty($element['#description'])) {
    $output .= '<div class="fieldset-description">' . $element['#description'] . '</div>';
  }
  $output .= $element['#children'];
  if (isset($element['#value'])) {
    $output .= $element['#value'];
  }
  $output .= '</div>';
  $output .= "</fieldset>\n";
  return $output;
}

/**
 * Returns HTML for a button form element.
 *
 * @param $variables
 *   An associative array containing:
 *   - element: An associative array containing the properties of the element.
 *     Properties used: #attributes, #button_type, #name, #value.
 *
 * @ingroup themeable
 */
function bootstrap_lite_button($variables) {

  if (is_array($variables['element']['#parents'])) {
    $count = count($variables['element']['#parents']);
    $button_type = '';
    if ($count > 0) {
      $button_type = $variables['element']['#parents'][$count - 1];
    }
  }

  $button_class = 'btn-default';

  switch ($button_type) {
    case 'submit':
      $button_class = 'btn-primary';
      break;
    case 'update':
      $button_class = 'btn-success';
      break;
    case 'clear':
    case 'check':
      $button_class = 'btn-warning';
      break;
    case 'preview':
      $button_class = 'btn-info';
      break;
    case 'delete':
    case 'cancel':
      $button_class = 'btn-danger';
      break;
  };

  if ($variables['element']['#value'] == t('Delete')) {
    $button_class = 'btn-danger';
  }

  if ($variables['element']['#value'] == t('Remove')) {
    $button_class = 'btn-danger';
  }

  $variables['element']['#attributes']['class'][] = 'btn';
  $variables['element']['#attributes']['class'][] = $button_class;


  return theme_button($variables);
}

/**
 * Returns HTML for an email form element.
 *
 * @param $variables
 *   An associative array containing:
 *   - element: An associative array containing the properties of the element.
 *     Properties used: #title, #value, #description, #size, #maxlength,
 *     #placeholder, #required, #attributes, #autocomplete_path.
 *
 * @ingroup themeable
 */
function bootstrap_lite_email($variables) {
  $variables['element']['#attributes']['class'][] = 'form-control';
  return theme_email($variables);
}

/**
 * Returns HTML for a textfield form element.
 *
 * @param $variables
 *   An associative array containing:
 *   - element: An associative array containing the properties of the element.
 *     Properties used: #title, #value, #description, #size, #maxlength,
 *     #placeholder, #required, #attributes, #autocomplete_path.
 *
 * @ingroup themeable
 */
function bootstrap_lite_textfield($variables) {
  $variables['element']['#attributes']['class'][] = 'form-control';
  return theme_textfield($variables);
}

/**
 * Returns HTML for a textarea form element.
 *
 * @param $variables
 *   An associative array containing:
 *   - element: An associative array containing the properties of the element.
 *     Properties used: #title, #value, #description, #rows, #cols,
 *     #placeholder, #required, #attributes
 *
 * @ingroup themeable
 */
function bootstrap_lite_textarea($variables) {
  $variables['element']['#attributes']['class'][] = 'form-control';
  return theme_textarea($variables);
}

/**
 * Returns HTML for a form element.
 *
 * Each form element is wrapped in a DIV container having the following CSS
 * classes:
 * - form-item: Generic for all form elements.
 * - form-type-#type: The internal element #type.
 * - form-item-#name: The internal form element #name (usually derived from the
 *   $form structure and set via form_builder()).
 * - form-disabled: Only set if the form element is #disabled.
 *
 * In addition to the element itself, the DIV contains a label for the element
 * based on the optional #title_display property, and an optional #description.
 *
 * The optional #title_display property can have these values:
 * - before: The label is output before the element. This is the default.
 *   The label includes the #title and the required marker, if #required.
 * - after: The label is output after the element. For example, this is used
 *   for radio and checkbox #type elements as set in system_element_info().
 *   If the #title is empty but the field is #required, the label will
 *   contain only the required marker.
 * - invisible: Labels are critical for screen readers to enable them to
 *   properly navigate through forms but can be visually distracting. This
 *   property hides the label for everyone except screen readers.
 * - attribute: Set the title attribute on the element to create a tooltip
 *   but output no label element. This is supported only for checkboxes
 *   and radios in form_pre_render_conditional_form_element(). It is used
 *   where a visual label is not needed, such as a table of checkboxes where
 *   the row and column provide the context. The tooltip will include the
 *   title and required marker.
 *
 * If the #title property is not set, then the label and any required marker
 * will not be output, regardless of the #title_display or #required values.
 * This can be useful in cases such as the password_confirm element, which
 * creates children elements that have their own labels and required markers,
 * but the parent element should have neither. Use this carefully because a
 * field without an associated label can cause accessibility challenges.
 *
 * @param $variables
 *   An associative array containing:
 *   - element: An associative array containing the properties of the element.
 *     Properties used: #title, #title_display, #description, #id, #required,
 *     #children, #type, #name.
 *
 * @ingroup themeable
 */
function bootstrap_lite_form_element($variables) {
  if (isset($variables['element']['#type'])) {
    if ($variables['element']['#type'] == 'checkbox') {
      $variables['element']['#wrapper_attributes']['class'][] = 'checkbox';
    }
    if ($variables['element']['#type'] == 'radio') {
      $variables['element']['#wrapper_attributes']['class'][] = 'radio';
    }
  }
  $description = FALSE;
  if (isset($variables['element']['#description'])) {
    $description = $variables['element']['#description'];
    unset($variables['element']['#description']);
  }
  $output = theme_form_element($variables);
  if ($description) {
    $output .= '<div class="description help-block">' . $description . "</div>\n";
  }
  return $output;
}

/**
 * Returns HTML for a password form element.
 *
 * @param $variables
 *   An associative array containing:
 *   - element: An associative array containing the properties of the element.
 *     Properties used: #title, #value, #description, #size, #maxlength,
 *     #placeholder, #required, #attributes.
 *
 * @ingroup themeable
 */
function bootstrap_lite_password($variables) {
  $variables['element']['#attributes']['class'][] = 'form-control';
  return theme_password($variables);
}

/**
 * Returns HTML for a search form element.
 *
 * @param $variables
 *   An associative array containing:
 *   - element: An associative array containing the properties of the element.
 *     Properties used: #title, #value, #description, #size, #maxlength,
 *     #placeholder, #required, #attributes, #autocomplete_path.
 *
 * @ingroup themeable
 */
function bootstrap_lite_search($variables) {

  if (isset($variables['element']['#attributes']['placeholder']) && $variables['element']['#attributes']['placeholder'] == t('Menu search')) {
    return theme_search($variables);
  }

  $variables['element']['#attributes']['class'][] = 'form-control';
  return theme_search($variables);
}

/**
 * Returns HTML for a select form element.
 *
 * It is possible to group options together; to do this, change the format of
 * $options to an associative array in which the keys are group labels, and the
 * values are associative arrays in the normal $options format.
 *
 * @param $variables
 *   An associative array containing:
 *   - element: An associative array containing the properties of the element.
 *     Properties used: #title, #value, #options, #description, #extra,
 *     #multiple, #required, #name, #attributes, #size.
 *
 * @ingroup themeable
 */
function bootstrap_lite_select($variables) {
  if (isset($variables['element']['#size'])) {
    unset($variables['element']['#size']);
  }
  $variables['element']['#attributes']['class'][] = 'form-control';
  return theme_select($variables);
}

/**
 * Implements hook_preprocess_table().
 */
function bootstrap_lite_preprocess_table(&$variables) {
  $variables['attributes']['class'][] = 'table';
  $variables['attributes']['class'][] = 'table-hover';
  if (!in_array('table-no-striping', $variables['attributes']['class'])) {
    $variables['attributes']['class'][] = 'table-striped';
  }
}

/**
 * Returns HTML for an individual permission description.
 *
 * @param $variables
 *   An associative array containing:
 *   - permission_item: An associative array representing the permission whose
 *     description is being themed. Useful keys include:
 *     - description: The text of the permission description.
 *     - warning: A security-related warning message about the permission (if
 *       there is one).
 *
 * @ingroup themeable
 */
function bootstrap_lite_user_permission_description($variables) {
  $description = array();
  $permission_item = $variables['permission_item'];
  if (!empty($permission_item['description'])) {
    $description[] = $permission_item['description'];
  }
  if (!empty($permission_item['warning'])) {
    $description[] = '<em class="permission-warning text-danger">' . $permission_item['warning'] . '</em>';
  }
  if (!empty($description)) {
    return implode(' ', $description);
  }
}

/**
 * Returns HTML for an administrative block for display.
 *
 * @param $variables
 *   An associative array containing:
 *   - block: An array containing information about the block:
 *     - show: A Boolean whether to output the block. Defaults to FALSE.
 *     - title: The block's title.
 *     - content: (optional) Formatted content for the block.
 *     - description: (optional) Description of the block. Only output if
 *       'content' is not set.
 *
 * @ingroup themeable
 */
function bootstrap_lite_admin_block($variables) {
  $block = $variables['block'];
  $output = '';

  // Don't display the block if it has no content to display.
  if (empty($block['show'])) {
    return $output;
  }

  $output .= '<div class="panel panel-default">';
  if (!empty($block['title'])) {
    $output .= '<div class="panel-heading"><h3 class="panel-title">' . $block['title'] . '</h3></div>';
  }
  if (!empty($block['content'])) {
    $output .= '<div class="body panel-body">' . $block['content'] . '</div>';
  }
  else {
    $output .= '<div class="description panel-body">' . $block['description'] . '</div>';
  }
  $output .= '</div>';

  return $output;
}

/**
 * Returns HTML for the output of the dashboard page.
 *
 * @param $variables
 *   An associative array containing:
 *   - menu_items: An array of modules to be displayed.
 *
 * @ingroup themeable
 */
function bootstrap_lite_system_admin_index($variables) {
  $menu_items = $variables['menu_items'];

  $stripe = 0;
  $container = array('left' => '', 'right' => '');
  $flip = array('left' => 'right', 'right' => 'left');
  $position = 'left';

  // Iterate over all modules.
  foreach ($menu_items as $module => $block) {
    list($description, $items) = $block;

    // Output links.
    if (count($items)) {
      $block = array();
      $block['title'] = $module;
      $block['content'] = theme('admin_block_content', array('content' => $items));
      $block['description'] = t($description);
      $block['show'] = TRUE;

      if ($block_output = theme('admin_block', array('block' => $block))) {
        if (!isset($block['position'])) {
          // Perform automatic striping.
          $block['position'] = $position;
          $position = $flip[$position];
        }
        $container[$block['position']] .= $block_output;
      }
    }
  }

  $output = '<div class="admin clearfix">';
  foreach ($container as $id => $data) {
    $output .= '<div class=" col-md-6 col-sm-12 clearfix">';
    $output .= $data;
    $output .= '</div>';
  }
  $output .= '</div>';

  return $output;
}

/**
 * Returns HTML for an administrative page.
 *
 * @param $variables
 *   An associative array containing:
 *   - blocks: An array of blocks to display. Each array should include a
 *     'title', a 'description', a formatted 'content' and a 'position' which
 *     will control which container it will be in. This is usually 'left' or
 *     'right'.
 *
 * @ingroup themeable
 */
function bootstrap_lite_admin_page($variables) {
  $blocks = $variables['blocks'];

  $stripe = 0;
  $container = array();

  foreach ($blocks as $block) {
    if ($block_output = theme('admin_block', array('block' => $block))) {
      if (empty($block['position'])) {
        // perform automatic striping.
        $block['position'] = ++$stripe % 2 ? 'left' : 'right';
      }
      if (!isset($container[$block['position']])) {
        $container[$block['position']] = '';
      }
      $container[$block['position']] .= $block_output;
    }
  }

  $output = '<div class="admin clearfix">';

  foreach ($container as $id => $data) {
    $output .= '<div class="clearfix  col-md-6 col-sm-12 ">';
    $output .= $data;
    $output .= '</div>';
  }
  $output .= '</div>';
  return $output;
}

/**
 * Returns HTML for primary and secondary local tasks.
 *
 * @param $variables
 *   An associative array containing:
 *     - primary: (optional) An array of local tasks (tabs).
 *     - secondary: (optional) An array of local tasks (tabs).
 *
 * @ingroup themeable
 * @see menu_local_tasks()
 */
function bootstrap_lite_menu_local_tasks(&$variables) {
  $output = '';

  if (!empty($variables['primary'])) {
    $variables['primary']['#prefix'] = '<h2 class="element-invisible">' . t('Primary tabs') . '</h2>';
    $variables['primary']['#prefix'] .= '<ul class="nav nav-tabs tabs-primary">';
    $variables['primary']['#suffix'] = '</ul>';
    $output .= drupal_render($variables['primary']);
  }
  if (!empty($variables['secondary'])) {
    $variables['secondary']['#prefix'] = '<h2 class="element-invisible">' . t('Secondary tabs') . '</h2>';
    $variables['secondary']['#prefix'] .= '<ul class="nav nav-pills tabs-secondary">';
    $variables['secondary']['#suffix'] = '</ul>';
    $output .= drupal_render($variables['secondary']);
  }

  return $output;
}

/**
 * Implements hook_links().
 */
function bootstrap_lite_links__dropbutton($menu) {
  foreach ($menu['links'] as $name => $settings) {
    $menu['links'][$name]['attributes']['class'][] = 'btn';
    $menu['links'][$name]['attributes']['class'][] = 'btn-default';
  }
  return theme_links($menu);
}

/**
 * Returns rendered HTML for the local actions.
 */
function bootstrap_lite_menu_local_actions(&$variables) {
  foreach ($variables['actions'] as $key => $link) {
    switch ($link['#link']['path']) {
      case 'admin/people/create':
        $variables['actions'][$key]['#link']['title'] = '<i class="fa fa-user-plus"></i>' . $link['#link']['title'];
        $variables['actions'][$key]['#link']['options']['html'] = TRUE;
        $variables['actions'][$key]['#link']['localized_options']['html'] = TRUE;
        break;
      default:
        $variables['actions'][$key]['#link']['title'] = '<i class="fa fa-plus"></i>' . $link['#link']['title'];
        $variables['actions'][$key]['#link']['options']['html'] = TRUE;
        $variables['actions'][$key]['#link']['localized_options']['html'] = TRUE;
    }
  }

  $output = drupal_render($variables['actions']);
  if ($output) {
    $output = '<ul class="nav nav-pills action-links">' . $output . '</ul>';
  }
  return $output;
}

/**
 * Implements hook_preprocess_breadcrumb().
 */
function bootstrap_lite_preprocess_breadcrumb(&$variables) {
  $breadcrumb = &$variables['breadcrumb'];

  // Optionally get rid of the homepage link.
  $show_breadcrumb_home = theme_get_setting('bootstrap_lite_breadcrumb_home');
  if (!$show_breadcrumb_home) {
    array_shift($breadcrumb);
  }
  if (theme_get_setting('bootstrap_lite_breadcrumb_title') && !empty($breadcrumb)) {
    $item = menu_get_item();
    $breadcrumb[] = !empty($item['tab_parent']) ? check_plain($item['title']) : drupal_get_title();
  }
}

/**
 * Returns HTML to wrap child elements in a container.
 *
 * Used for grouped form items. Can also be used as a #theme_wrapper for any
 * renderable element, to surround it with a <div> and add attributes such as
 * classes or an HTML id.
 *
 * @param $variables
 *   An associative array containing:
 *   - element: An associative array containing the properties of the element.
 *     Properties used: #id, #attributes, #children.
 *
 * @ingroup themeable
 */
function bootstrap_lite_container($variables) {
  if (isset($variables['element']['#attributes']['class'][0]) && $variables['element']['#attributes']['class'][0] == 'views-display-column') {
    $variables['element']['#attributes']['class'] = array('col-xs-12', 'cols-sm-12', 'col-md-4');
  }
  return theme_container($variables);
}

/**
 * Display a view as a table style.
 */
function bootstrap_lite_preprocess_views_view_table(&$variables) {
  $variables['classes'][] = 'table';
}

/**
 * Implements hook_form_alter().
 */
function bootstrap_lite_form_alter(array &$form, array &$form_state = array(), $form_id = NULL) {
  if ($form_id) {
    if (isset($form['actions']['cancel']) && isset($form['actions']['cancel']['#type']) && $form['actions']['cancel']['#type'] == 'link') {
      $form['actions']['cancel']['#options']['attributes']['class'][] = 'btn';
      $form['actions']['cancel']['#options']['attributes']['class'][] = 'btn-default';
    }
    if (isset($form['actions']['cancel_form']) && $form['actions']['cancel_form']['#type'] == 'link') {
      $form['actions']['cancel']['#options']['attributes']['class'][] = 'btn';
      $form['actions']['cancel']['#options']['attributes']['class'][] = 'btn-default';
    }
  }
}

/**
 * Overrides theme_node_add_list().
 *
 * Display the list of available node types for node creation.
 */
function bootstrap_lite_node_add_list($variables) {
  $content = $variables['content'];
  $output = '';
  if ($content) {
    $output = '<ul class="list-group">';
    foreach ($content as $item) {
      $title = '<h4 class="list-group-item-heading">' . $item['title'] . '</h4>';
      if (isset($item['description'])) {
        $title .= '<p class="list-group-item-text">' . filter_xss_admin($item['description']) . '</p>';
      }
      $item['localized_options']['attributes']['class'][] = 'list-group-item';
      $item['localized_options']['html'] = TRUE;
      $output .= l($title, $item['href'], $item['localized_options']);
    }
    $output .= '</ul>';
  }
  else {
    $output = '<p>' . t('You have not created any content types yet. Go to the <a href="@create-content">content type creation page</a> to add a new content type.', array('@create-content' => url('admin/structure/types/add'))) . '</p>';
  }
  return $output;
}

/**
 * Overrides theme_admin_block_content().
 *
 * Use unordered list markup in both compact and extended mode.
 */
function bootstrap_lite_admin_block_content($variables) {
  return bootstrap_lite_node_add_list($variables);
}

/**
 * Process variables for user-picture.tpl.php.
 *
 * The $variables array contains the following arguments:
 * - $account: A user, node or comment object with 'name', 'uid' and 'picture'
 *   fields.
 *
 * @see user-picture.tpl.php
 */
function bootstrap_lite_preprocess_user_picture(&$variables) {
  // print_r($variables);
//  $variables['user_picture'] = '';
  /*  if (config_get('system.core', 'user_pictures')) {
    $account = $variables['account'];
    if (!empty($account->picture)) {
    // @TODO: Ideally this function would only be passed file entities, but
    // since there's a lot of legacy code that JOINs the {users} table to
    // {node} or {comments} and passes the results into this function if we
    // a numeric value in the picture field we'll assume it's a file id
    // and load it for them. Once we've got user_load_multiple() and
    // comment_load_multiple() functions the user module will be able to load
    // the picture files in mass during the object's load process.
    if (is_numeric($account->picture)) {
    $account->picture = file_load($account->picture);
    }
    if (!empty($account->picture->uri)) {
    $filepath = $account->picture->uri;
    }
    }
    elseif (config_get('system.core', 'user_picture_default')) {
    $filepath = config_get('system.core', 'user_picture_default');
    }
    if (isset($filepath)) {
    $alt = t("@user's picture", array('@user' => user_format_name($account)));
    // If the image does not have a valid drupal scheme (for eg. HTTP),
    // don't load image styles.
    if (module_exists('image') && file_valid_uri($filepath) && $style = config_get('system.core', 'user_picture_style')) {
    $variables['user_picture'] = theme('image_style', array('style_name' => $style, 'uri' => $filepath, 'alt' => $alt, 'title' => $alt, 'attributes' => array('class' => 'img-circle')));
    }
    else {
    $variables['user_picture'] = theme('image', array('uri' => $filepath, 'alt' => $alt, 'title' => $alt, 'attributes' => array('class' => 'img-circle')));
    }
    if (!empty($account->uid) && user_access('access user profiles')) {
    $attributes = array('attributes' => array('title' => t('View user profile.')), 'html' => TRUE);
    $variables['user_picture'] = l($variables['user_picture'], "user/$account->uid", $attributes);
    }
    }
    } */
}

/**
 * Implements hook_preprocess_comment().
 */
function bootstrap_lite_preprocess_comment(&$variables) {
//  print_r($variables);
  if (theme_get_setting('bootstrap_lite_datetime')) {
    $comment = $variables['elements']['#comment'];
    $variables['timeago'] = t('@time ago', array('@time' => format_interval(time() - $comment->changed)));
  }
}

/**
 * Implements hook_preprocess_node().
 */
function bootstrap_lite_preprocess_node(&$variables) {
  if (theme_get_setting('bootstrap_lite_datetime')) {
    $node = $variables['elements']['#node'];
    $variables['timeago'] = t('@time ago', array('@time' => format_interval(time() - $node->created)));
  }
}

/**
 * Implements theme_status_messages().
 */
function asocolderma_status_messages($variables) {
  $display = $variables['display'];
  $output = '';

  $status_heading = array(
    'status' => t('Status message'),
    'error' => t('Error message'),
    'warning' => t('Warning message'),
    'info' => t('Informative message'),
  );

  // Map Drupal message types to their corresponding Bootstrap classes.
  // @see http://twitter.github.com/bootstrap/components.html#alerts
  $status_class = array(
    'status' => 'success',
    'error' => 'danger',
    'warning' => 'warning',
    'info' => 'info',
  );
  foreach (drupal_get_messages($display) as $type => $messages) {
    $class = (isset($status_class[$type])) ? ' alert-' . $status_class[$type] : '';
    $output .= "<div class=\"popUps messages alert alert-block$class\">\n";
    $output .= "  <a class=\"close\" data-dismiss=\"alert\" href=\"#\">&times;</a>\n";

    if (!empty($status_heading[$type])) {
      $output .= '<h4 class="element-invisible">' . $status_heading[$type] . "</h4>\n";
    }
    /* switch ($type) {
      case 'success':
      $output .= '<i class="fa fa-check"></i> ';
      break;
      case 'error':
      $output .= '<i class="fa fa-times"></i> ';
      break;
      case 'warning':
      $output .= '<i class="fa fa-exclamation-triangle"></i> ';
      break;
      case 'info':
      default:
      $output .= '<i class="fa fa-info-circle"></i> ';
      } */
    if (count($messages) > 1) {
      $output .= " <ul>\n";
      foreach ($messages as $message) {
        $output .= '  <li>' . $message . "</li>\n";
      }
      $output .= " </ul>\n";
    }
    else {
      $output .= $messages[0];
    }

    $output .= "</div>\n";
  }
  return $output;
}

/**
 * implements theme_menu_link().
 */
function bootstrap_lite_menu_link(array $variables) {
  $element = $variables['element'];
  $sub_menu = '';

  if ($element['#below']) {
    // Prevent dropdown functions from being added to management menu so it
    // does not affect the navbar module.
    if (($element['#original_link']['menu_name'] == 'management') && (module_exists('navbar'))) {
      $sub_menu = drupal_render($element['#below']);
    }
    elseif ((!empty($element['#original_link']['depth'])) && ($element['#original_link']['depth'] == 1)) {
      // Add our own wrapper.
      unset($element['#below']['#theme_wrappers']);
      $sub_menu = '<ul class="dropdown-menu">' . drupal_render($element['#below']) . '</ul>';
      // Generate as standard dropdown.
      $element['#title'] .= ' <span class="caret"></span>';
      $element['#attributes']['class'][] = 'dropdown';
      $element['#localized_options']['html'] = TRUE;

      // Set dropdown trigger element to # to prevent inadvertant page loading
      // when a submenu link is clicked.
      $element['#localized_options']['attributes']['data-target'] = '#';
      $element['#localized_options']['attributes']['class'][] = 'dropdown-toggle';
      $element['#localized_options']['attributes']['data-toggle'] = 'dropdown';
    }
  }
  // On primary navigation menu, class 'active' is not set on active menu item.
  // @see https://drupal.org/node/1896674
  if (($element['#href'] == $_GET['q'] || ($element['#href'] == '<front>' && drupal_is_front_page())) && (empty($element['#localized_options']['language']))) {
    $element['#attributes']['class'][] = 'active';
  }
  $output = l($element['#title'], $element['#href'], $element['#localized_options']);
  return '<li' . drupal_attributes($element['#attributes']) . '>' . $output . $sub_menu . "</li>\n";
}

function bootstrap_lite_menu_tree__system_primary_menu($variables) {
  $navbar_menu_position = theme_get_setting('bootstrap_lite_navbar_menu_position');
  return '<ul class="menu nav navbar-nav ' . $navbar_menu_position . ' primary-menu">' . $variables['tree'] . '</ul>';
}

function bootstrap_lite_menu_tree__system_secondary_menu($variables) {
  return '<ul class="menu nav navbar-nav navbar-right secondary-menu">' . $variables['tree'] . '</ul>';
}

/**
 * Returns HTML for a breadcrumb trail.
 *
 * @param $variables
 *   An associative array containing:
 *   - breadcrumb: An array containing the breadcrumb links.
 */
function asocolderma_breadcrumb($variables) {
  if (drupal_is_front_page()) {
    return '';
  }
  global $user;
  $breadcrumb = $variables['breadcrumb'];

  $user_a = user_load($user->uid);
  //if (in_array('dermatologo', $user->roles)) {
  $title = drupal_get_title();
  $domain = domain_get_domain();
  $inicio = l('Inicio', $domain['path']);
  $breadcrumb[0] = $inicio;
  $urlBase = $domain["path"];
  $showUrl = true;
  $title_init = "Inicio";
  switch ($domain["subdomain"]) {
    case 'asocoldermadev.org':
      $path = drupal_get_path_alias($_GET['q']);
      if ($path === "dermatologos") {
        $showUrl = false;
      }
      $auxPath = explode("/", $path);
      if (isset($auxPath[0]) && $auxPath[0] == "dermatologos") {
        $urlBase .= "dermatologos";
      }
      if ($path === "preguntas_frecuentes" && $user->uid == 0) {
        $title_init = "Inicio";
      }
      if ((arg(0) == 'search' && arg(1) == 'results') || (arg(0) == 'custom' && arg(1) == 'search')) {
        $search_id = $_GET['search_id'];
        $ids = explode('-', $search_id);
        $items = variable_get('custom_search_items_' . $ids[0], array());
        foreach ($items as $key => $value) {
          if ($value['id'] == $ids[1]) {
            $title = $value['etiqueta'];
          }
        }
      }
      break;
  }
  $output = '';
  if (!empty($breadcrumb) && $showUrl) {


    $output .= '<nav role="navigation">';
    // Provide a navigational heading to give context for breadcrumb links to
    // screen-reader users. Make the heading invisible with .element-invisible.
    $output .= '<h2 class="element-invisible">' . t('You are here') . '</h2>';
    $output .= '<ol  class="breadcrumb" >';
    $count = 1;
    foreach ($breadcrumb as $item) {
      if ($count == count($breadcrumb)) {
        $output .= '<li>' . $title . '</li>';
      }
      elseif ($count == 1) {
        $output .= '<li class="active"><a href="' . $urlBase . '">' . $title_init . '</a></li>';
      }
      else {
        // $output .= '<li>' . $item . '</li>';
      }
      $count ++;
    }
    $output .= '</ol></nav>';
    return $output;
  }
  //}

  return '';
}


function asocolderma_preprocess_html(&$vars) {
  $domain = domain_get_domain();
  $urlBase = $domain["path"];
  switch ($domain["subdomain"]) {
    case 'asocoldermadev.org':
      $path = drupal_get_path_alias($_GET['q']);
      $auxPath = explode("/", $path);
      if (isset($auxPath[0]) && $auxPath[0] == "dermatologos") {
        foreach ($vars['classes_array'] as $keycss => $valuecss) {
          if ($valuecss == 'not-logged-in') {
            unset($vars['classes_array'][$keycss]);
          }
        }
        $vars['classes_array'][] = 'page-dermatologos';
      }
      break;
  }
  if (arg(0) == 'programacion-eventos') {
    drupal_add_js(libraries_get_path('bxslider') . "/jquery.bxslider.min.js",
    array('type' => 'file', 'scope' => 'footer', 'weight' => 5)
  );
drupal_add_css(libraries_get_path('bxslider') . "/jquery.bxslider.css", array('group' => CSS_DEFAULT, 'every_page' => TRUE));  	
$termId = arg(1);
$date_find = isset($_GET['field_fecha%5Bvalue%5D%5Bdate%5D'])?$_GET['field_fecha%5Bvalue%5D%5Bdate%5D']:"0";
if (!isset($_GET['field_fecha'])){
  $json = file_get_contents( getBaseUrl() . 'programacion-eventosjson/' . $termId . '/fecha.json');
  $obj = json_decode($json);
  $status = 0;
  foreach ($obj->nodes as $valor) {
    $porciones = explode("/", $valor->node->fecha);
    if ($porciones[2] == arg(2) && $status == 0) {
     // dpm($porciones);
      $status= 1;
      $iduser = isset($_GET["field_conferencista_target_id"])?$_GET["field_conferencista_target_id"]:"";
      header( 'Location: ' .  getBaseUrl() . 'programacion-eventos/'.arg(1) .'/'.arg(2) .'?field_sal_n_tid=All&field_fecha%5Bvalue%5D%5Bdate%5D=' . $porciones[0] .'%2F' . $porciones[1] .'%2F' . $porciones[2] .'&field_tema_tid=All&field_conferencista_target_id=' . $iduser );
      exit();
    }
  }
}
drupal_add_js('jQuery(document).ready(function () {
  var arrayIndexDate = []; 
  var htmltitle = jQuery("body").find(".title-contenido-evento").html();
  if (jQuery("#load_filter").find("#edit-field-sal-n-tid-wrapper").length === 0) {
    var html = jQuery(".view-id-programacion_eventos").find(".view-filters").html();
    jQuery("#load_filter").html(html);
  }
  var url_salon = "field_sal_n_tid=All";
  var url_tema = "field_tema_tid=All";
  var url_conf = "field_conferencista_target_id";
  var statusddate = 0;
  jQuery(".filtro_programa_academico").find("#edit-field-sal-n-tid").on("change", function (e) {
      var optionSelected = jQuery("option:selected", this);
      var valueSelected = this.value;
      jQuery(".view-id-programacion_eventos").find("#edit-field-sal-n-tid").val(valueSelected);
      var salon = jQuery("#load_filter").find("select[name=field_sal_n_tid]").val();
      var tema = jQuery("#load_filter").find("select[name=field_tema_tid]").val();
      var confe = jQuery("#load_filter").find("select[name=field_conferencista_target_id]").val();

      var datefind = jQuery("#block-system-main").find("#edit-field-fecha-value-date").val();
      var argdate = "&field_fecha%5Bvalue%5D%5Bdate%5D=mes%2Fdia%2F' . arg(2) . '";
      var filtedatefield = "";
      if (datefind.length > 0) {
        var auxFechaLink = datefind.split("/");
        if (auxFechaLink.length > 0) {
          var urllinkdia = argdate.replace("dia", auxFechaLink[1]);
          var url_redire = urllinkdia.replace("mes", auxFechaLink[0]);
          filtedatefield = url_redire;
        }
      }
      var url_redire = "/' . arg(0) . '/' . arg(1) . '/' . arg(2) . '?field_sal_n_tid=" + salon  + filtedatefield + "&field_tema_tid="+ tema + "&field_conferencista_target_id=" + confe;
      window.location.href = url_redire;
  });
  jQuery(".filtro_programa_academico").find("#edit-field-tema-tid").on("change", function (e) {
    var salon = jQuery("#load_filter").find("select[name=field_sal_n_tid]").val();
    var tema = jQuery("#load_filter").find("select[name=field_tema_tid]").val();
    var confe = jQuery("#load_filter").find("select[name=field_conferencista_target_id]").val();

    var datefind = jQuery("#block-system-main").find("#edit-field-fecha-value-date").val();
    var argdate = "&field_fecha%5Bvalue%5D%5Bdate%5D=mes%2Fdia%2F' . arg(2) . '";
    var filtedatefield = "";
    if (datefind.length > 0) {
      var auxFechaLink = datefind.split("/");
      if (auxFechaLink.length > 0) {
        var urllinkdia = argdate.replace("dia", auxFechaLink[1]);
        var url_redire = urllinkdia.replace("mes", auxFechaLink[0]);
        filtedatefield = url_redire;
      }
    }
    var url_redire = "/' . arg(0) . '/' . arg(1) . '/' . arg(2) . '?field_sal_n_tid=" + salon + filtedatefield + "&field_tema_tid="+ tema + "&field_conferencista_target_id=" + confe;
    window.location.href = url_redire;
  });
  jQuery(".filtro_programa_academico").find("#edit-field-conferencista-target-id").on("change", function (e) {
    var salon = jQuery("#load_filter").find("select[name=field_sal_n_tid]").val();
    var tema = jQuery("#load_filter").find("select[name=field_tema_tid]").val();
    var confe = jQuery("#load_filter").find("select[name=field_conferencista_target_id]").val();

    var datefind = jQuery("#block-system-main").find("#edit-field-fecha-value-date").val();
    var argdate = "&field_fecha%5Bvalue%5D%5Bdate%5D=mes%2Fdia%2F' . arg(2) . '";
    var filtedatefield = "";
    if (datefind.length > 0) {
      var auxFechaLink = datefind.split("/");
      if (auxFechaLink.length > 0) {
        var urllinkdia = argdate.replace("dia", auxFechaLink[1]);
        var url_redire = urllinkdia.replace("mes", auxFechaLink[0]);
        filtedatefield = url_redire;
      }
    }
    var url_redire = "/' . arg(0) . '/' . arg(1) . '/' . arg(2) . '?field_sal_n_tid=" + salon + filtedatefield +"&field_tema_tid="+ tema + "&field_conferencista_target_id=" + confe;
    window.location.href = url_redire;
  });
  var d = new Date();
  var fielddate = d.getMonth() + "/01/' . arg(2) . '";
  if (fielddate !== undefined) {
    var listday = jQuery("<ul>",{class: "col-sm-9", id: "carruselFechas"});
    var date_find = jQuery("#load_filter").find("#edit-field-fecha-value-date").val();
    console.log(date_find);
    jQuery.getJSON( "/programacion-eventosjson/' . $termId . '/fecha.json?year=", function( data ) {
      jQuery.each( data.nodes, function( keyk, valk ) {
        var fg = valk.node.fecha;
        var fgAux =fg.split("/");
        if (fgAux[2] == "' . arg(2) . '" && statusddate === 0) {
          fielddate = valk.node.fecha;
          statusddate = 1;
        }
      });
      var auxFecha = fielddate.split("/");
      var items = [];
      var weekday = new Array(7);
      weekday[0]=  "Dom";
      weekday[1] = "Lun";
      weekday[2] = "Mar";
      weekday[3] = "Mie";
      weekday[4] = "Jue";
      weekday[5] = "Vie";
      weekday[6] = "Sab";
      var mesyear = new Array(12);
      mesyear[1]=  "Ene";
      mesyear[2] = "Feb";
      mesyear[3] = "Mar";
      mesyear[4] = "Abr";
      mesyear[5] = "May";
      mesyear[6] = "Jun";
      mesyear[7] = "Jul";
      mesyear[8] = "Ago";
      mesyear[9] = "Sep";
      mesyear[10] = "Oct";
      mesyear[11] = "Nov";
      mesyear[12] = "Dic";
      var intnumer = parseInt(auxFecha[0]);
      jQuery(".mes-current").html(mesyear[intnumer]);
      jQuery(".mes-next").html(mesyear[intnumer]).addClass("mes-current");
      jQuery(".mes-previous").html(mesyear[intnumer]).addClass("mes-current");
        jQuery.each( data.nodes, function( key, val ) {
          
          var auxdate = val.node.fecha;
          if (arrayIndexDate.indexOf(val.node.fecha) < 0 && arrayIndexDate.length < 5) {
            var auxdateSplit = auxdate.split("/");
            console.log("year", auxdateSplit[0] + "===" +  auxFecha[0]);
            console.log("year", auxdateSplit[2] + "===" +  "' . arg(2) . '");
            if (auxdateSplit[0] ===  auxFecha[0] && auxdateSplit[2] ===  "' . arg(2) . '") {
              arrayIndexDate.push(val.node.fecha);
              var d = new Date(auxdateSplit[2], auxdateSplit[0]-1, auxdateSplit[1], 0, 0, 0, 0);
              var linkFecha = jQuery("<a>",{
                html: auxdateSplit[1] + "<span>" + weekday[d.getDay()] + " </span>" ,
                href: "javascript:",
                alt: auxdate,
                class: "link_datefind"
              }).click(function() {
                var datafind = jQuery(this).attr("alt");
                var urllinkdia = "/' . arg(0) . '/' . arg(1) . '/' . arg(2) . '?field_sal_n_tid=All&field_fecha%5Bvalue%5D%5Bdate%5D=mes%2Fdia%2F' . arg(2) . '&field_tema_tid=All&field_conferencista_target_id="
                var auxFechaLink = datafind.split("/");
                urllinkdia = urllinkdia.replace("dia", auxFechaLink[1]);
                var url_redire = urllinkdia.replace("mes", auxFechaLink[0]);
                jQuery("#block-system-main").find("#edit-field-fecha-value-date").val(datafind);
                window.location.href = url_redire; 
              });
              var listLi = jQuery("<li>", {
                html: linkFecha,
                class: "col-sm-2"
              });
              if (auxdate ===  date_find) {
                linkFecha.addClass("active");
              }
              listday.append(listLi);
            }
          }
        });
        jQuery("#filtro_uno_programa_fecha").append(listday);
        jQuery("#carruselFechas").css("margin-top","-16px");
    });
  }
  setTimeout(function(){  var totanlres = jQuery( ".view-grouping" ).length; if (totanlres === 0) {jQuery("#block-system-main").append( "<div class=\'mesaje-no-res\'>La consulta no arrojo ningun resultado </div>" );}    console.log("Hello::"+ totanlres); }, 1000);
});', array('type' => 'inline', 'scope' => 'footer', 'weight' => 7));
  }



  if (arg(0) == 'directorio_dermatologos') {
    $letra = array();
    $index = 0;
    $js_hidden = '';
    for($i=65; $i<=90; $i++) {  
      $lchat = chr($i);
      $letra[] = $lchat; 
      $query = db_select('users', 'u');
      $query->join('users_roles', 'ur', 'u.uid = ur.uid');
      $query->join('field_data_field_mostrar_mi_perfil_a_los_pa', 'fb', 'u.uid = fb.entity_id');
      $query->join('field_data_field_nombres', 'fn', 'u.uid = fn.entity_id');
      $query->fields('u', array('uid'));
      $query->condition('ur.rid', '4', '=');
      $query->condition('fn.entity_type', 'user', '=');
      $query->condition('fb.entity_type', 'user', '=');
      $query->condition('fb.field_mostrar_mi_perfil_a_los_pa_value', 1, '=');
      $query->condition('fn.field_nombres_value', $lchat . '%', 'LIKE');
      $query->range(0,1);
      $results=$query->execute()->fetchAssoc();
      if (!isset($results['uid'])) {
        $js_hidden .= 'jQuery("body").find(".alpha-pagination-list li").eq(' . $index . ').addClass("inactive");
        jQuery("body").find(".alpha-pagination-list li").eq(' . $index . ').removeClass("active");
        jQuery("body").find(".alpha-pagination-list li").eq(' . $index . ').html("<span>' . $lchat . '</span>");';
      }
      $index++;
      
    }
    $arg_find = arg(1);
    if (in_array($arg_find, $letra)) {
      $key = array_keys($letra, $arg_find);
      if (array_keys($letra, $arg_find)) {
        if (isset($key[0])) {
          $js_hidden .= 'jQuery("body").find(".alpha-pagination-list li").eq(' . $key[0] . ').addClass("inactive");';
        }
      }
    }
    drupal_add_js('jQuery(document).ready(function () {' . $js_hidden  .' });', array('type' => 'inline', 'scope' => 'footer', 'weight' => 7));
  }
}

/* Ç±  HOOK que renderizar las opciones de logeo, registro y reinicio de Password ↓ */

/**
 *  implement asocolderma_userconfi().
 */
function asocolderma_theme($existing, $type, $theme, $path) {
  // print "<h1>HOOK Custom</h1>";
  $items = array();

  $items['user_login'] = array(
    'render element' => 'form',
    'path' => drupal_get_path('theme', 'asocolderma') . '/templates',
    'template' => 'user-login',
    'preprocess functions' => array(
      'asocolderma_preprocess_user_login'
    ),
  );
  $items['user_register_form'] = array(
    'render element' => 'form',
    'path' => drupal_get_path('theme', 'asocolderma') . '/templates',
    'template' => 'user-register-form',
    'preprocess functions' => array(
      'asocolderma_preprocess_user_register'
    ),
  );
  $items['user_pass'] = array(
    'render element' => 'form',
    'path' => drupal_get_path('theme', 'asocolderma') . '/templates',
    'template' => 'user-pass',
    'preprocess functions' => array(
      'asocolderma_preprocess_user_pass'
    ),
  );
  $items['user_edit_public'] = array(
    'render element' => 'form',
    'path' => drupal_get_path('theme', 'asocolderma') . '/templates',
    'template' => 'user-edit-public',
    // 'variables' =>  array('form'  =>  NULL, 'user_id' =>  NULL, 'total_rows' =>  NULL),
    'variables' => array('form' => NULL, 'user_id' => NULL, 'total_views' => NULL),
    'preprocess functions' => array(
      'asocolderma_preprocess_user_edit_public'
    ),
  );
  $items['user_edit_autor_revista'] = array(
    'render element' => 'form',
    'path' => drupal_get_path('theme', 'asocolderma') . '/templates',
    'template' => 'user-autor-revista',
    'variables' => array('form' => NULL),
    'preprocess functions' => array(
      'asocolderma_preprocess_user_edit_autor'
    ),
  );
  $items['user_edit_private'] = array(
    'render element' => 'form',
    'path' => drupal_get_path('theme', 'asocolderma') . '/templates',
    'template' => 'user-edit-private',
    'variables' => array('form' => NULL, 'user_id' => NULL),
    'preprocess functions' => array(
      'asocolderma_preprocess_user_edit_private'
    ),
  );
  $items['user_edit_config'] = array(
    'render element' => 'form',
    'path' => drupal_get_path('theme', 'asocolderma') . '/templates',
    'template' => 'user-edit-config',
    'variables' => array('form' => NULL, 'user_id' => NULL),
    'preprocess functions' => array(
      'asocolderma_preprocess_user_edit_config'
    ),
  );
  $items['user_edit_servicios'] = array(
    'render element' => 'form',
    'path' => drupal_get_path('theme', 'asocolderma') . '/templates',
    'template' => 'user-edit-servicios',
    'variables' => array('form' => NULL, 'user_id' => NULL, 'total_views' => NULL),
    'preprocess functions' => array(
      'asocolderma_preprocess_user_edit_servicios'
    ),
  );
  $items['page_dermatologos'] = array(
    'render element' => 'form',
    'path' => drupal_get_path('theme', 'asocolderma') . '/templates',
    'template' => 'page-dermatologos',
    'variables' => array('form' => NULL, 'user_id' => NULL),
    'preprocess functions' => array(
      'asocolderma_preprocess_page_dermatologos'
    ),
  );
  $items['register_autor_revista'] = array(
    'render element' => 'form',
    'path' => drupal_get_path('theme', 'asocolderma') . '/templates',
    'template' => 'register-autor-revista',
    'variables' => array('form' => NULL, 'user_id' => NULL),
    'preprocess functions' => array(
      'asocolderma_preprocess_register_autor'
    ),
  );
  $items['user_estadisticas'] = array(
    'render element' => 'form',
    'path' => drupal_get_path('theme', 'asocolderma') . '/templates',
    'template' => 'user-page-estadisticas',
    'variables' => array('user_id' => NULL, 'total_views' => NULL, 'num_visitas_meses' => NULL, 'año_actual' => NULL, 'years' => NULL),
    'preprocess functions' => array(
      'asocolderma_preprocess_estadisticas_perfil'
    ),
  );
  $items['aviso'] = array(
    'render element' => 'form',
    'path' => drupal_get_path('theme', 'asocolderma') . '/templates',
    'template' => 'aviso',
    'variables' => array('form' => NULL),
    'preprocess functions' => array(
      'asocolderma_preprocess_estadisticas_perfil'
    ),
  );
  return $items;
}

function asocolderma_preprocess_user_login(&$vars) {
  $path = base_path() . path_to_theme();
  $vars['logo_path'] = $path . '/img/logo_asocolderma.PNG';
}

function asocolderma_preprocess_user_register($vars) {
  print "entro";
  // $vars['intro_text'] = t('This is my super awesome reg form'); // TEXTO -A T-RADUCIR MEDIANTE LA FUNCION 't'
}

function asocolderma_preprocess_user_pass(&$vars) {
  $path = base_path() . path_to_theme();
  $vars['logo_path'] = $path . '/img/logo_asocolderma.PNG';
}

function asocolderma_preprocess_user_edit_public($vars) {
  // print $vars;
  // global $user;
}

function asocolderma_preprocess_user_edit_autor($vars) {
  // print $vars;
  // global $user;
}

function asocolderma_preprocess_user_edit_private($vars) {
  // print $vars;
  // $vars['intro_text'] = t('This is my super awesome request new password form'); // TEXTO A TRADUCIR MEDIANTE LA FUNCION 't'
}

function asocolderma_preprocess_user_edit_config($vars) {
  // dpm($vars);
  //print render($vars['form']['#groups']['group_column1_public']);
}

function asocolderma_preprocess_user_edit_servicios($vars) {
  // dpm($vars);
  //print render($vars['form']['#groups']['group_column1_public']);
}

function asocolderma_preprocess_page_dermatologos($vars) {
  // dpm($vars);
  //print render($vars['form']['#groups']['group_column1_public']);
}

function asocolderma_preprocess_register_autor($vars) {
  // dpm($vars);
  //print render($vars['form']['#groups']['group_column1_public']);
}

function asocolderma_preprocess_estadisticas_perfil($vars) {
  // dpm($vars);
  //print render($vars['form']['#groups']['group_column1_public']);
}

/**
 * Get latest visitors for block content.
 */
/* function asocolderma_user_visits_total($limit = 7) {
  global $user;
  $output = '';

  if ($user->uid) {
  // Initialize the total number of visits to the users profile page.
  $total = 0;
  $total += user_visits_adv_get('total', $user->uid);
  // Retrieve the history of the users profile visits and add it
  // up to a clean history array.
  $history_visits = user_visits_adv_get('history', $user->uid);
  $history = array_fill(user_visits_adv_get_history_key(REQUEST_TIME) - $limit + 1, $limit, 0);
  foreach ($history as $key => $visits) {
  if (!empty($history_visits[$key])) {
  $history[$key] += $history_visits[$key];
  }
  }
  $output = $total;
  }
  return $output;
  } */


/* Ç±  HOOK que renderizar las opciones de logeo, registro y reinicio de Password ↑ */
/* function asocolderma_menu_link(array $variables) {
  global $user;
  $element = $variables['element'];
  dpm($element);
  $sub_menu = '';

  if ($element['#below']) {
  $sub_menu = drupal_render($element['#below']);
  }
  $title = '';
  // Check if the user is logged in, that you are in the correct menu,
  // and that you have the right menu item
  if ($user->uid != 0 && $element['#theme'] == 'menu_link__user_menu' && $element['#title'] == t('My account')) {
  $element['#title'] = $user->name;
  // Add 'html' = TRUE to the link options
  $element['#localized_options']['html'] = TRUE;
  // Load the user picture file information; Unnecessary if you use theme_user_picture()
  $fid = $user->picture;
  $file = file_load($fid);
  // I found it necessary to use theme_image_style() instead of theme_user_picture()
  // because I didn't want any extra html, just the image.
  $title = theme('image_style', array('style_name' => 'thumbnail', 'path' => $file->uri, 'alt' => $element['#title'], 'title' => $element['#title'])) . $element['#title'];
  } else {
  $title = $element['#title'];
  }
  $output = l($title, $element['#href'], $element['#localized_options']);
  return '<li' . drupal_attributes($element['#attributes']) . '>' . $output . $sub_menu . "</li>\n";
  } */

/* function asocolderma_menu_link($item) {
  dpm($item);
  // Make all new admin links hidden (a.k.a disabled).
  if (strpos($item['link_path'], 'admin') === 0 && empty($item['mlid'])) {
  $item['hidden'] = 1;
  }
  // Flag a link to be altered by hook_translated_menu_link_alter().
  if ($item['link_path'] == 'devel/cache/clear') {
  $item['options']['alter'] = TRUE;
  }
  // Flag a link to be altered by hook_translated_menu_link_alter(), but only
  // if it is derived from a menu router item; i.e., do not alter a custom
  // menu link pointing to the same path that has been created by a user.
  if ($item['link_path'] == 'user' && $item['module'] == 'system') {
  $item['options']['alter'] = TRUE;
  }
  } */
function asocolderma_menu_link_alter(&$item) {
  // dpm($item);
  /* // Example 1 - make all new admin links hidden (a.k.a disabled).
    if (strpos($item['link_path'], 'admin') === 0 && empty($item['mlid'])) {
    $item['hidden'] = 1;
    }
    // Example 2  - flag a link to be altered by hook_translated_menu_link_alter()
    if ($item['link_path'] == 'devel/cache/clear') {
    $item['options']['alter'] = TRUE;
    } */
}

function asocolderma_menu_alter(&$items) {
  // dpm($items);
  // $items['node/%node/workflow']['access callback'] = '_my_function';
}

function _my_function() {
  return true;
}

function asocolderma_select($variables) {
  $element = $variables['element'];
  element_set_attributes($element, array('id', 'name', 'size'));
  _form_set_class($element, array('form-select'));

  return '<select' . drupal_attributes($element['#attributes']) . '>'
      . asocolderma_form_select_options($element) . '</select>';
}

function asocolderma_form_select_options($element, $choices = NULL) {
  if (!isset($choices)) {
    $choices = $element['#options'];
  }
  // array_key_exists() accommodates the rare event 
  // where $element['#value'] is NULL. 
  // isset() fails in this situation.
  $value_valid = isset($element['#value']) || array_key_exists('#value', $element);
  $value_is_array = $value_valid && is_array($element['#value']);
  $options = '';
  foreach ($choices as $key => $choice) {
    if (is_array($choice)) {
      $options .= '<optgroup label="' . $key . '">';
      $options .= form_select_options($element, $choice);
      $options .= '</optgroup>';
    }
    elseif (is_object($choice)) {
      $options .= form_select_options($element, $choice->option);
    }
    else {
      $key = (string) $key;

      $attributes = "";
      if (isset($element['#option_attributes'][$key])) {
        $attributes = drupal_attributes($element['#option_attributes'][$key]);
      }


      if ($value_valid && (!$value_is_array && (string) $element['#value'] === $key || ($value_is_array && in_array($key, $element['#value'])))) {
        $selected = ' selected="selected"';
      }
      else {
        $selected = '';
      }


      $options .= '<option ' . $attributes
          . ' value="' . check_plain($key) . '"' . $selected . '>'
          . check_plain($choice) . '</option>';
    }
  }
  return $options;
}

function asocolderma_form_comment_form_alter(&$form, &$form_state) {
  global $user;
  $usuario = user_load($user->uid);
  $dr_a = $usuario->field_sexo['und'][0]['value'] == 1 ? 'Dra.' : 'Dr.';
  $nombre = $dr_a . ' ' . $usuario->field_nombres['und'][0]['value'] . ' ' . $usuario->field_apellidos['und'][0]['value'];
  $node = menu_get_object();
  $form['comment_body'][LANGUAGE_NONE][0]['#format'] = 'only_image';
  $form['comment_body']['und'][0]['#title'] = 'Hacer un comentario';
  $form['author']['#prefix'] = '<div style ="display:none">';
  $form['author']['#suffix'] = '</div>';
  $form['actions']['submit']['#value'] = 'Publicar como ' . $nombre;
  $form['#validate'][] = 'asocolderma_comment_extra_validate';
}

function asocolderma_comment_extra_validate($form, &$form_state) {
  if (trim(strip_tags($form_state['values']['comment_body']['und'][0]['value'])) == '') {
    $url = url('node/' . $form_state['values']['nid']);
    drupal_goto($url);
    return FALSE;
  }
}
