<?php

function kasseb_lightbox_config_form($form, &$form_state) {
    $config = variable_get('kasseb_lightbox_config', array());
    if ( isset($config) ) {
        $video = $config['video'];
        $image_banner_desktop = $config['image_banner_desktop'];
        $image_banner_mobile = $config['image_banner_mobile'];
        $active = $config['active'];
    } else {
        $video = '';
        $image_banner_desktop = 0;
        $image_banner_mobile = 0;
        $active = '';
    }
    $form['video'] = array(
        '#type' => 'textfield',
        '#title' => 'URL del video',
        '#maxlength' => 255,
        '#description' => 'URL del video que saldrá en el banner',
        '#default_value' => $video
    );
    $form['image_banner_desktop'] = array(
        '#title' => t('Imagen Banner 600x600'),
        '#type'  => 'managed_file',
        '#description' => t('Banner de publicidad Desktop.'),
        '#default_value' => $image_banner_desktop,
        '#upload_location' => 'public://kasseb_images/'
    );
    $form['image_banner_mobile'] = array(
        '#title' => t('Imagen Banner 300x250'),
        '#type'  => 'managed_file',
        '#description' => t('Banner de publicidad Movil.'),
        '#default_value' => $image_banner_mobile,
        '#upload_location' => 'public://kasseb_images/'
    );
    $form['active'] = array(
        '#type' => 'radios',
        '#title' => '¿LightBox Promocional activado?',
        '#options' => array(1 => 'Si', 0 => 'No'),
        '#description' => 'Indica si el lightbox debe aparecer o no',
        '#required' => TRUE,
        '#default_value' => $active
    );

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => "Actualizar",
    );

    return $form;
}

function kasseb_lightbox_config_form_submit($form, &$form_state) {
    global $user;
    $config = variable_get('kasseb_lightbox_config', array());
    $config['video']  = $form_state['values']['video'];
    $config['active'] = $form_state['values']['active'];

    $file = file_load($form_state['values']['image_banner_desktop']);
    if( $file ){
        $file->status = FILE_STATUS_PERMANENT;
        file_save($file);
        file_usage_add($file, 'kasseb', 'user', $user->uid);
        $config['image_banner_desktop']  = $file->fid;
    }else{
        $config['image_banner_desktop'] = '';
    }

    $file = file_load($form_state['values']['image_banner_mobile']);
    if( $file ){
        $file->status = FILE_STATUS_PERMANENT;
        file_save($file);
        file_usage_add($file, 'kasseb', 'user', $user->uid);
        $config['image_banner_mobile']  = $file->fid;
    }else{
        $config['image_banner_mobile'] = '';
    }

    variable_set('kasseb_lightbox_config', $config);
    drupal_set_message('Configuración Actualizada.');
}