<?php

/**
 * @file
 * Custom views handler definition.
 *
 * Place this code in
 * /sites/all/[custom_module_name]/includes/views_handler_visitas_meses_field.inc
 */

/**
 * Custom handler class.
 *
 * @ingroup views_field_handlers
 */
class views_handler_time_ago_field extends views_handler_field {

  /**
   * {@inheritdoc}
   *
   * Perform any database or cache data retrieval here. In this example there is
   * none.
   */
  function query() {
    
  }

  /**
   * {@inheritdoc}
   *
   * Modify any end user views settings here. Debug $options to view the field
   * settings you can change.
   */
  function option_definition() {
    $options = parent::option_definition();
    return $options;
  }

  /**
   * {@inheritdoc}
   *
   * Make changes to the field settings form seen by the end user when adding
   * your field.
   */
  function options_form(&$form, &$form_state) {
    parent::options_form($form, $form_state);
  }
  /**
   * Render callback handler.
   *
   * Return the markup that will appear in the rendered field.
   */
  function render($data) {
    if ($data->_field_data['nid']['entity_type'] == 'node') {
      // $node = node_load($data->nid);
      // dpm($node);
      // dpm($data);
      // $timeago=get_timeago(strtotime($row['post_date']));
      $ptime = $data->node_created;
      $estimate_time = time() - $ptime;

      if( $estimate_time < 1 )
      {
          return 'Justo ahora';
      }

      $condition = array( 
        12 * 30 * 24 * 60 * 60  =>  'año',
        30 * 24 * 60 * 60       =>  'mes',
        24 * 60 * 60            =>  'día',
        60 * 60                 =>  'hora',
        60                      =>  'minuto',
        1                       =>  'segundo'
      );

      foreach( $condition as $secs => $str )
      {
        $d = $estimate_time / $secs;

        if( $d >= 1 )
        {
            $r = round( $d );
            return $output = 'Hace ' . $r . ' ' . $str . ( $r > 1 ? ($str == 'mes' ? 'es' : 's') : '' );
        }
      }
    }
    //http://stackoverflow.com/questions/1416697/converting-timestamp-to-time-ago-in-php-e-g-1-day-ago-2-days-ago Formato Fecha Time ago
    /*$grupo = array();
    $grupo['1']['mes'] = 'enero';
    $grupo['1']['visitas'] = '318';
    $output = '<p class="mes">enero</p>';*/
    // return $output;
  }

}
