/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/
(function ($, Drupal, drupalSettings) {
  $(document).ready(function () {
    // Set chart options
    var options = {
      title: '',
        hAxis:{
          title: '',
          format: 'M'
        },
        vAxis:{
          title: ''
        },
        legend: 'none',
        width:"100%",
    };
    const year_current = drupalSettings.asocol_statistics.years[0];

    google.charts.load('current', {'packages':['corechart']});
    google.charts.setOnLoadCallback(drawChart);

    // Callback that creates and populates a data table,
    // instantiates the pie chart, passes in the data and
    // draws it.
    function drawChart() {
      getDataTable(year_current);
    }

    // $('#select-year').once().each(function() {
    //   $(this).change(function () {
    //     getDataTable($(this).val());
    //     $('#year').text($(this).val());
    //   });
    // });

    once('select-year', '#select-year', context).forEach((el) => {
        $(el).on('change', function () {
          getDataTable($(this).val());
          $('#year').text($(this).val());
        });
      });

    once('submit-year', '#submit-year', context).forEach((el) => {
        $(el).on('click', function () {
          getDataTable($('#select-year').val());
          $('#year').text($('#select-year').val());
        });
      });

    // $('#submit-year').once().each(function() {
    //   $(this).click(function () {
    //     getDataTable($('#select-year').val());
    //     $('#year').text($('#select-year').val());
    //   });
    // });

    function getDataTable(year) {
      var data = new google.visualization.DataTable();
      data.addColumn('string', 'Mes');
      data.addColumn('number', 'Visitas');
      data.addColumn({type:'string', role:'style'});
      data.addColumn({type:'string', role:'annotation'});
      data.addRows(drupalSettings.asocol_statistics.years_statistics[year]);

      // Instantiate and draw our chart, passing in some options.
      var chart = new google.visualization.ColumnChart(document.getElementById('chart_div'));
      chart.draw(data, options);
    }

    // $('#submit-compare').once().each(function() {
    //   $(this).click(function () {
    //     getDatatableLineChart();
    //   });
    // });

    once('submit-compare', '#submit-compare', context).forEach((el) => {
        $(el).on('click', function () {
          getDatatableLineChart();
        });
      });

    function getDatatableLineChart() {
      $('#year').text(drupalSettings.asocol_statistics.years_compare_label);
      var optionsLineChart = {
        hAxis: {
          title: ''
        },
        vAxis: {
          title: ''
        },
        colors: ['#ff7d29', '#008b8f'],
        width:"100%",
      };

      var data = new google.visualization.DataTable(drupalSettings.asocol_statistics.years_compare);

      // Instantiate and draw our chart, passing in some options.
      var chart = new google.visualization.LineChart(document.getElementById('chart_div'));
      chart.draw(data, optionsLineChart);
    }

    function printElem(elem) {
        var mywindow = window.open('', 'PRINT', 'height=400,width=600');

        mywindow.document.write('<html><head><title>' + document.title  + '</title>');
        mywindow.document.write('</head><body >');
        mywindow.document.write('<h1>' + document.title  + '</h1>');
        mywindow.document.write(document.getElementById(elem).innerHTML);
        mywindow.document.write('</body></html>');

        mywindow.document.close(); // necessary for IE >= 10
        mywindow.focus(); // necessary for IE >= 10*/

        mywindow.print();
        mywindow.close();

        return true;
    }

  });

})(jQuery, Drupal, drupalSettings);
